
on getAccounts()
	local theAccounts
	tell application id "com.microsoft.Outlook"
		set theAccounts to {}
		set theAccounts to theAccounts & exchange accounts
		set theAccounts to theAccounts & imap accounts
		set theAccounts to theAccounts & pop accounts
		return theAccounts
	end tell
end getAccounts

on getName(theRef)
	tell application id "com.microsoft.Outlook" to return name of theRef
end getName

on getMailboxes()
	tell application id "com.microsoft.Outlook" to return mail folders -- of on my computer
end getMailboxes

on getAccountSubMailboxes(theMailFolder)
	tell application id "com.microsoft.Outlook" to return mail folders of theMailFolder
end getAccountSubMailboxes

on getSubMailboxes(theMailFolder)
	tell application id "com.microsoft.Outlook" to return mail folders of theMailFolder
end getSubMailboxes

on getMailboxMessageCount(theMailFolder)
	try
		tell application id "com.microsoft.Outlook" to return count of messages of theMailFolder
	end try
	return 0
end getMailboxMessageCount

on getMailboxUnreadMessageCount(theMailFolder)
	try
		tell application id "com.microsoft.Outlook" to return unread count of theMailFolder
	end try
	return 0
end getMailboxUnreadMessageCount

on getMailboxMessages(theMailFolder)
	try
		tell application id "com.microsoft.Outlook" to return messages of theMailFolder
	end try
	return {}
end getMailboxMessages

on getMailboxType(theMailFolder)
	try
		local draftsFolder, sentFolder, theName
		tell application id "com.microsoft.Outlook"
			set sentFolder to sent items
			if theMailFolder is equal to sentFolder then return "sent"
			set theName to (name of theMailFolder as string)
			if (name of mail folders of sentFolder) contains theName then return "sent"
			
			(* set draftsFolder to drafts
			if theMailFolder is equal to draftsFolder then return "drafts"
			if (name of mail folders of draftsFolder) contains theName then return "drafts" *)
		end tell
	end try
	return ""
end getMailboxType

on getMessageProperties(theMessage)
	local isFlagged, isDeleted, isRead, dateReceived, theHeaders, theCategories
	tell application id "com.microsoft.Outlook"
		set theCategories to {}
		tell theMessage to set {theHeaders, isFlagged, isDeleted, isRead, dateReceived} to {headers, todo flag is completed, is marked for delete, is read, time received}
		repeat with theCategory in ((categories of theMessage) as list)
			set theCategories to theCategories & (name of theCategory)
		end repeat
		return {|headers|:theHeaders, |categories|:theCategories, |dateReceived|:dateReceived, deleted:isDeleted, |read|:isRead, flagged:isFlagged}
	end tell
end getMessageProperties

on getMessageSource(theMessage)
	tell application id "com.microsoft.Outlook" to return source of theMessage
end getMessageSource

on getSelectedMessages()
	tell application id "com.microsoft.Outlook" to return selected objects
end getSelectedMessages

on getSelectedMailboxes()
	tell application id "com.microsoft.Outlook"
		if selected folder is not missing value then return {selected folder}
	end
end getSelectedMailboxes

on setOffline(theFlag)
	tell application id "com.microsoft.Outlook" to set working offline to theFlag
end setOffline
